% 3D graphics - Mesh, Surface, Contour,Gradient 
format compact 
set(gcf,'Menubar','none','Name','Grficos 3D', ... 
    'NumberTitle','off','Position',[10,50,600,600], ... 
    'Color',[0.8 0.8 0.8]); 
%*************plot information 
nc = 15;  % nmeros de contornos
x = -4:0.1:4; 
y = -4:0.1:4; 
[X Y] = meshgrid(x,y); 
R = sqrt(X.*X + Y.*Y); 
Z = sin(2*R)./(R + 0.001); % cria a funo chapu mexicano
%******************************************** 
subplot('Position',[0.15 0.15 0.3 0.3]); 
colormap(jet) 

h =mesh(x,y,Z);  % mesh plot 
ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
xlabel('x', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul 
zlabel('z', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
title('\bf\it3D Mesh','Color','k', ... 
    'VerticalAlignment','bottom') 

subplot('Position',[0.65 0.15 0.3 0.3]); 
surf(x,y,Z);   % surface plot 
shading interp 
ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
xlabel('x', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul 
zlabel('z', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul 
title('\bf\it3D Surface plot','Color','k', ... 
    'VerticalAlignment','bottom') 
  

subplot('Position',[0.15 0.65 0.3 0.3]); 
[c,h] = contour3(x,y,Z,nc); %  3D contour plot 
set(h,'LineWidth',1)  % muda a espessura da linha 
ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
xlabel('x', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul 
zlabel('z', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
title('\bf\it3D contour','Color','k', ... 
    'VerticalAlignment','bottom') 

subplot('Position',[0.65 0.65 0.3 0.3]); 
clear x y X Y R Z 
x = -4:0.5:4; % reduz a densidade da malha 
y = -4:0.5:4; 
[X Y] = meshgrid(x,y); 
R = sqrt(X.*X + Y.*Y); 
Z = sin(2*R)./(R + 0.001); 
[U,V,W] = surfnorm(X,Y,Z); % cria a normal  superfcie 
h = surf(X,Y,Z); 
shading interp 
hold on; 
h1 = quiver3(X,Y,Z,U,V,W); 
hold off 

ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
xlabel('x', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul 
zlabel('z', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom');  % negrito azul
title('\bf\itSurface Normals','Color','k', ... 
    'VerticalAlignment','bottom'); 
