% Grficos 3D - vrios line plots (usando matrizes) 
% Adaptado de: Dr. P.Venkataraman 
% A trajetria de uma partcula no espao tridimensional
format compact 
set(gcf,'Menubar','none','Name','Mutiple 3D Line Plot', ... 
         'NumberTitle','off','Position',[10,350,400,300]); 
t = 0:0.1:3; 
title('\bf\itMultiple plots using Matrices','Color','k', ... 
         'VerticalAlignment','bottom') 
% create plots 
x = 2*sin(2*t); 
y1 = 3*cos(2*t); 
y2 = 2*exp(0.3*t); 
z1 = t; 
z2 = 1 + 0.5*t.*t; 
h = plot3([x' x'],[y1' y2'],[z1' z2'], ...  % Matrizes de duas colunas
    'LineWidth',2); 
set(h(2),'LineStyle','--'); % configura o estilo da segunda linha (tracejada)
hold on 
for i=1:length(t) 
    if i> 1 
        delete(h2); % apaga o primeiro marcador
        delete(h3); % apaga o segundo marcador
    end 
    h2 = plot3(x(i),y1(i),z1(i),'bo','MarkerFaceColor','r'); % cria o primeiro marcador 
    h3 = plot3(x(i),y2(i),z2(i),'ms','MarkerFaceColor','y'); % cria o segundo marcador 
    pause(0.1) % pra o grfico, seno no se pode ver a animao
end 
hold off 
ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom'); % negrito azul
xlabel('x', ... 
     'FontWeight','b','Color','b', ... 
     'VerticalAlignment','bottom');  % negrito azul 
zlabel('z', ... 
     'FontWeight','b','Color','b', ... 
     'VerticalAlignment','bottom');  % negrito azul
title('\bf\itMultiple plots using Matrices','Color','k', ... 
         'VerticalAlignment','bottom') 
grid 
