% Grficos 3D - line plot 
% Adaptado de: Dr. P.Venkataraman 
% A trajetria de uma partcula no espao tridimensional
format compact 
set(gcf,'Menubar','none','Name','3D Line Plot - Trajetria e Velocidade', ... 
         'NumberTitle','off','Position',[10,350,400,300]); 
t = 0:0.1:3; 

x = 2*sin(2*t); 
y = 3*cos(2*t); 
z = t; 
h1 = plot3(x,y,z, ...  %trajetria
    'LineWidth',2, ... 
    'Color','k'); 
% animation ----- 
axis([-3 3 -5 6 0 4]); 
hold on 
for i=1:length(t) 
    if i> 1 
        delete(h2); % apaga o marcador 
        delete(h3); % apaga a linha 
    end 
    h2 = plot3(x(i),y(i),z(i),'bo','MarkerFaceColor','r'); % cria um marcador  
    h3 = line([x(i) x(i)],[y(i) y(i)],[0 z(i)],'Color','r'); %cria uma linha vertical
    pause(.1) % pra o grfico, seno no se pode ver a animao
end 
delete(h3); 
%------------------------------------- 
% ttulo em negrito itlico, na cor preta  
title('\bf\it3D Line Plot e Vetor velocidade','Color','k', ... 
         'VerticalAlignment','bottom') 
ylabel('y', ... 
    'FontWeight','b','Color','b', ... 
    'VerticalAlignment','bottom'); % negrito azul
xlabel('x', ... 
     'FontWeight','b','Color','b', ... 
     'VerticalAlignment','bottom'); % negrito azul
zlabel('z', ... 
     'FontWeight','b','Color','b', ... 
     'VerticalAlignment','bottom'); % negtito azul

quiver3(x,y,z,4*cos(2*t),-6*sin(2*t),1,2,'b') %plota o vetor velocidade
hold off 

textstr(1)={'x = 2Sin(2*t)'}; 
textstr(2)={'y = 3Cos(2*t)'}; 
textstr(3)={'z = t'}; 
text(1.5,4,2,textstr,'FontWeight','b') 
  
