%
%  Estatica: Operacoes com vetores
%  Nome :  OperacoesVetor.m
%
%  Adaptado de Dr. P. Venkataraman, Mar 2006
%
%  Para executar este arquivo localmente
%  1.  Abra o MATLAB
%  2.  Abra o arquivo OperacoesVetor.m no Editor do MATLAB
%  3.  Execute o arquivo/codigo
%
%----- INICIO  Formulacao do problema -------------------------------------
% Os cavaleiros nativos americanos estao arrastanto um tronco
% para a oficina para esculpir uma nova canoa.
% A forca ao longo da corda OA, FOA e 2000N. Os componentes do vetor
% OA [Ax, Ay, Az] sao [1.5, 2, 2] m.
% A forca ao longo da corda OB, FOB e 2500N. Os componentes do vetor
% OB [Bx, By, Bz] sao [-1, 3, 2.2] m.
%
% (a) Encontre os componentes de FOA.
% (b) Encontre os componente da força FOB.
% (c) Encontre a força total F no tronco.
% (d) Encontre os cossenos direcao de F.%
%----- FIM  Formulacao do problema ----------------------------------------
%
%-----  CONTROLANDO A SAIDA DE DADOS
%
% Assume-se que todos os problemas serao executados de forma independente
% e portanto, todas as variaveis antigas podem ser liberadas.
clear        % Comente se precisar manter algumas variaveis
clc          % Coloca o cursor no topo da tela
format short % valores numericos com 5 casas decimais
%
%--------------------------------------------------------------------------
%----- DEFINE/IMPRIME Titulo do Problema ----------------------------------

prob_title = 'Estatica: Operacoes com vetores';  % define titulo
upper_pt = upper(prob_title);      % converte para maiuscula
fprintf('   %s     \n\n',upper_pt);

%--------------------------------------------------------------------------
%-- ATRIBUI/ORGANIZA DADOS DO PROBLEMA ------------------------------------

FOA = 2000;    FOB =2500;   % Magnitude das duas forcas
OA = [1.5 2 2];             % Vetor OA - vetor linha
OB = [-1 3 2.2];            % Vetor OB

%--------------------------------------------------------------------------
%   ----- Parte (a) -------------------------------------------------------
eOA = OA/norm(OA);          % vetor unitario eOA
                            % norm(OA) e a norma Euclideana de OA
                            % calcula a magnitude do vetor OA

FOAV =FOA*eOA;              % componentes do vetor de forca
%--------------------------------------------------------------------------
%   ----- Parte (b) -------------------------------------------------------
eOB = OB/norm(OB);          % vetor unitario eOB
                            % norm(OB) e a norma Euclideana de OB
                            % calcula a magnitude do vetor OB

FOBV =FOB*eOB;              % componentes do vetor de forca
%--------------------------------------------------------------------------
%   ----- Parte (c) -------------------------------------------------------
FV = FOAV + FOBV;           % soma vetorial das forcas
%--------------------------------------------------------------------------
%   ----- Parte (d) -------------------------------------------------------
FVmag = norm(FV);                   % Magnitude da Forca F
alpha = acos(FV(1)/FVmag)*180/pi;   % Angulo de direcao alpha
                                    % above includes radian to degree
                                    % conversion
beta = acos(FV(2)/FVmag)*180/pi;    % angulo de direcao beta
gamma = acos(FV(3)/FVmag)*180/pi;   % angulo de direcao gamma
%--------------------------------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                O PROBLEMA foi resolvido acima                   %%%%%
%%%%%      As sentencas seguintes sao uteis para imprimir             %%%%%
%%%%%                 os resultados ordenadamente                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%-----    IMPRIMINDO OS RESULTADOS ----------------------------------------
fprintf('Parte(a)\n');
fprintf('-------\n');
fprintf('Forca FOA = %6.3f i + %6.3f j + %6.3f k  [N]\n\n',FOAV)

fprintf('Parte(b)\n');
fprintf('-------\n');
fprintf('Forca FOB = %6.3f i + %6.3f j + %6.3f k  [N]\n\n',FOBV)

fprintf('Parte(c)\n');
fprintf('-------\n');
fprintf('Forca F = %6.3f i + %6.3f j + %6.3f k  [N]\n\n',FV)

fprintf('Parte(d)\n');
fprintf('-------\n');
fprintf('alpha : %6.3f  [deg]\n',alpha)
fprintf('beta  : %6.3f  [deg]\n',beta)
fprintf('gamma : %6.3f  [deg]\n\n\n',gamma)
%--------------------------------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%        As sentencas seguintes criarao um grafico (PLOT)         %%%%%
%%%%%        baseado nos resultados numericos                         %%%%%
%%%%%                                                                 %%%%%
%%%%%        Esta secao nao e necessaria mas extremamente util        %%%%%
%%%%%        para conhecer melhor a programacao no MATLAB,            %%%%%
%%%%%        aprender sobre os graficos no MATLAB e                   %%%%%
%%%%%        fazer a ferramenta trabalhar para voce.                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%--------------------------------------------------------------------------
ORG = [0 0 0];  % define origem

set(gcf,'Name','Operacoes com Vetores','Number','Off');
% define o titulo da figura e que nao tera um numero
grid  % desenha uma grade
ylabel('y ', ...
    'FontWeight','b','Color','b', ...
    'VerticalAlignment','bottom');  % eixo y - negrito azul
xlabel('x ', ...
    'FontWeight','b','Color','b', ...
    'VerticalAlignment','bottom');  % eixo x - negrito azul
zlabel('z ', ...
    'FontWeight','b','Color','b', ...
    'VerticalAlignment','bottom');  % eixo z - negrito azul

axis([-1000 1000 0 4000 0 4000]);   % Define os limites da figura
view(45,45)

% desenha linha a partir da Origem até o ponto A
lineOA = line([0 FOAV(1)], [0 FOAV(2)],[0 FOAV(3)]);
%%%%% Define propriedade da linha
set(lineOA,'Color','b','LineWidth',2,'LineStyle','-');

% desenha linha tracejada
lineOAz = line([FOAV(1) FOAV(1)], [FOAV(2) FOAV(2)], [0 FOAV(3)]);
%%%%% Define propriedade da linha
set(lineOAz,'Color','k','LineWidth',1,'LineStyle','--');

lineOB = line([0 FOBV(1)], [0 FOBV(2)],[0 FOBV(3)]);
%%%%% Define propriedade da linha
set(lineOB,'Color','r','LineWidth',2,'LineStyle','-');

lineOBz = line([FOBV(1) FOBV(1)], [FOBV(2) FOBV(2)], [0 FOBV(3)]);
%%%%% Define propriedade da linha
set(lineOBz,'Color','k','LineWidth',1,'LineStyle','--');

% desenha OB novamente a partir do ponto A
lineOAOB = line([FOAV(1) FV(1)], [FOAV(2) FV(2)],[FOAV(3) FV(3)]);
%%%%% Define propriedade da linha
set(lineOAOB,'Color','r','LineWidth',2,'LineStyle','-');

% desenha o vetor a partir da origem
lineF = line([0 FV(1)], [0 FV(2)],[0 FV(3)]);
%%%%% Define propriedade da linha
set(lineF,'Color','g','LineWidth',2,'LineStyle','-');

lineFz = line([FV(1) FV(1)], [FV(2) FV(2)], [0 FV(3)]);
%%%%% Define propriedade da linha
set(lineFz,'Color','k','LineWidth',1,'LineStyle','--');

%  localiza a origem
text(0,0,0,'O', ...
    'FontWeight','b','Color','k');
% localiza o ponto A e insere a letra A
text(FOAV(1),FOAV(2),FOAV(3),'A  ', ...
    'FontWeight','b','Color','k');
% localiza o ponto C e insere a letra C
text(FV(1),FV(2),FV(3),'C  ', ...
    'FontWeight','b','Color','k');


title('\bf\it Operacoes com Vetores','Color','k', ...
    'VerticalAlignment','bottom')

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%     FIM DO CODIGO                                                       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
